/*
 * Decompiled with CFR 0.152.
 */
package com.github.phylogeny.jeienchantmentinfo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod(value="jeienchantmentinfo")
@JeiPlugin
public class JEIEnchantmentInfo
implements IModPlugin {
    public static final String MOD_ID = "jeienchantmentinfo";

    public ResourceLocation getPluginUid() {
        return new ResourceLocation(MOD_ID, "jei");
    }

    public void registerRecipes(IRecipeRegistration registration) {
        String missingDescription = I18n.m_118938_((String)this.getLangKey("missing_desc"), (Object[])new Object[0]);
        String conflictsTitle = "\n" + I18n.m_118938_((String)this.getLangKey("conflicts"), (Object[])new Object[0]);
        String maxLevelKey = this.getLangKey("max_level");
        String typeKey = this.getLangKey("type");
        String typeKeyPrefix = typeKey + ".";
        boolean escapePercents = ((ModContainer)ModList.get().getModContainerById("minecraft").get()).getModInfo().getVersion().getMinorVersion() == 15;
        ForgeRegistries.ENCHANTMENTS.getValues().forEach(enchantment -> {
            String enchantmentKey = enchantment.m_44704_();
            Object description = missingDescription;
            for (String suffix2 : Arrays.asList("desc", "description")) {
                String descriptionKey = enchantmentKey.replace(".minecraft.", ".jeienchantmentinfo.") + "." + suffix2;
                String descriptionTemp = I18n.m_118938_((String)descriptionKey, (Object[])new Object[0]);
                if (escapePercents) {
                    descriptionTemp = descriptionTemp.replace("%", "%%");
                }
                if (descriptionKey.equals(descriptionTemp)) continue;
                description = descriptionTemp;
                break;
            }
            description = ChatFormatting.BOLD + ChatFormatting.UNDERLINE + I18n.m_118938_((String)enchantmentKey, (Object[])new Object[0]) + ChatFormatting.RESET + "\n" + (String)description;
            EnchantmentCategory type = enchantment.f_44672_;
            ArrayList<String> types = new ArrayList<String>();
            if (type.name().equals("ALL") || type.m_7454_(Items.f_42522_)) {
                types.add("vanishable");
            } else if (type.m_7454_(Items.f_42740_)) {
                types.add("breakable");
            } else {
                if (type.m_7454_(Items.f_42741_)) {
                    types.add("wearable");
                } else {
                    boolean helmet = type.m_7454_(Items.f_42468_);
                    boolean chestplate = type.m_7454_(Items.f_42469_);
                    boolean leggings = type.m_7454_(Items.f_42470_);
                    boolean boots = type.m_7454_(Items.f_42471_);
                    if (helmet && chestplate && leggings && boots) {
                        types.add("armor");
                    } else {
                        if (helmet) {
                            types.add("armor.helmet");
                        }
                        if (chestplate) {
                            types.add("armor.chestplate");
                        }
                        if (leggings) {
                            types.add("armor.leggings");
                        }
                        if (boots) {
                            types.add("armor.boots");
                        }
                    }
                }
                if (type.m_7454_(Items.f_42384_)) {
                    types.add("tool");
                } else if (type.m_7454_(Items.f_42386_)) {
                    types.add("axe");
                }
                if (type.m_7454_(Items.f_42383_)) {
                    types.add("sword");
                }
                if (type.m_7454_(Items.f_42523_)) {
                    types.add("fishing_rod");
                }
                if (type.m_7454_(Items.f_42713_)) {
                    types.add("trident");
                }
                if (type.m_7454_(Items.f_42411_)) {
                    types.add("bow");
                }
                if (type.m_7454_(Items.f_42717_)) {
                    types.add("crossbow");
                }
            }
            description = (String)description + "\n" + I18n.m_118938_((String)typeKey, (Object[])new Object[]{types.stream().map(suffix -> I18n.m_118938_((String)(typeKeyPrefix + suffix), (Object[])new Object[0])).collect(Collectors.joining(", "))});
            int maxLevel = enchantment.m_6586_();
            description = (String)description + "\n" + I18n.m_118938_((String)maxLevelKey, (Object[])new Object[]{maxLevel});
            StringBuilder conflictBuilder = new StringBuilder();
            ForgeRegistries.ENCHANTMENTS.getValues().stream().filter(enchantment2 -> enchantment != enchantment2 && !enchantment.m_44695_(enchantment2)).forEach(enchantment2 -> conflictBuilder.append("\n-").append(I18n.m_118938_((String)enchantment2.m_44704_(), (Object[])new Object[0])));
            String conflicts = conflictBuilder.toString();
            if (!conflicts.isEmpty()) {
                description = (String)description + conflictsTitle + conflicts;
            }
            List books = IntStream.range(1, maxLevel + 1).mapToObj(i -> {
                ItemStack book = new ItemStack((ItemLike)Items.f_42690_);
                EnchantedBookItem.m_41153_((ItemStack)book, (EnchantmentInstance)new EnchantmentInstance(enchantment, i));
                return book;
            }).collect(Collectors.toList());
            registration.addIngredientInfo(books, VanillaTypes.ITEM, new Component[]{new TextComponent((String)description)});
        });
    }

    private String getLangKey(String name) {
        return String.join((CharSequence)".", "enchantment", MOD_ID, name);
    }
}

